/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.core.pr;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GsonUtils;
import org.eclipse.egit.github.core.service.IssueService;
import org.eclipse.egit.github.core.service.PullRequestService;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.github.core.GitHub;
import org.eclipse.mylyn.internal.github.core.QueryUtils;
import org.eclipse.mylyn.internal.github.core.RepositoryConnector;
import org.eclipse.mylyn.internal.github.core.issue.IssueConnector;
import org.eclipse.mylyn.internal.github.core.pr.Messages;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestAttribute;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestComposite;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestTaskDataHandler;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;

public class PullRequestConnector
extends RepositoryConnector {
    public static final String SEGMENT_PULL = "/pull";
    public static final String KIND = "githubPullRequests";
    private final PullRequestTaskDataHandler taskDataHandler = new PullRequestTaskDataHandler(this);

    public static String getRepositoryLabel(IRepositoryIdProvider repo) {
        return String.valueOf(repo.generateId()) + Messages.PullRequestConnector_LabelPullRequests;
    }

    public static TaskRepository createTaskRepository(Repository repo, String username, String password, boolean isToken) {
        String url = PullRequestConnector.appendPulls(GitHub.createGitHubUrl(repo.getOwner().getLogin(), repo.getName()));
        TaskRepository repository = new TaskRepository(KIND, url);
        repository.setRepositoryLabel(PullRequestConnector.getRepositoryLabel((IRepositoryIdProvider)repo));
        String loginName = username;
        if (loginName == null && isToken) {
            loginName = "";
        }
        if (loginName != null && password != null) {
            repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials(loginName, password), true);
        }
        repository.setCategory("org.eclipse.mylyn.category.review");
        repository.setProperty(GitHub.PROPERTY_USE_TOKEN, Boolean.toString(isToken));
        return repository;
    }

    public static String appendPulls(String repoUrl) {
        return String.valueOf(repoUrl) + "/pulls";
    }

    public static String stripPulls(String repoUrl) {
        if (repoUrl.endsWith("/pulls")) {
            return repoUrl.substring(0, repoUrl.length() - "/pulls".length());
        }
        return repoUrl;
    }

    public static PullRequestComposite getPullRequest(TaskData data) {
        if (data == null) {
            return null;
        }
        String value = PullRequestAttribute.MODEL.getMetadata().getValue(data);
        if (value.length() == 0) {
            return null;
        }
        return (PullRequestComposite)GsonUtils.fromJson((String)value, PullRequestComposite.class);
    }

    public static RepositoryId getRepository(String prRepoUrl) {
        return GitHub.getRepository(PullRequestConnector.stripPulls(prRepoUrl));
    }

    public String getConnectorKind() {
        return KIND;
    }

    public String getLabel() {
        return Messages.PullRequestConnector_Label;
    }

    public AbstractTaskDataHandler getTaskDataHandler() {
        return this.taskDataHandler;
    }

    public IStatus performQuery(TaskRepository repository, IRepositoryQuery query, TaskDataCollector collector, ISynchronizationSession session, IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        List<String> statuses = QueryUtils.getAttributes("state", query);
        monitor.beginTask(Messages.PullRequestConnector_TaskFetching, statuses.size());
        try {
            RepositoryId repo = PullRequestConnector.getRepository(repository.getRepositoryUrl());
            GitHubClient client = IssueConnector.createClient(repository);
            PullRequestService service = new PullRequestService(client);
            IssueService commentService = new IssueService(client);
            for (String status : statuses) {
                List pulls = service.getPullRequests((IRepositoryIdProvider)repo, status);
                for (PullRequest pr : pulls) {
                    pr = service.getPullRequest((IRepositoryIdProvider)repo, pr.getNumber());
                    PullRequestComposite prComp = new PullRequestComposite();
                    prComp.setRequest(pr);
                    List comments = null;
                    if (pr.getComments() > 0) {
                        comments = commentService.getComments(repo.getOwner(), repo.getName(), Integer.toString(pr.getNumber()));
                    }
                    if (pr.getCommits() > 0) {
                        prComp.setCommits(service.getCommits((IRepositoryIdProvider)repo, pr.getNumber()));
                    }
                    TaskData taskData = this.taskDataHandler.createTaskData(repository, monitor, (IRepositoryIdProvider)repo, prComp, comments);
                    collector.accept(taskData);
                }
                monitor.worked(1);
            }
        }
        catch (IOException e) {
            result = GitHub.createWrappedStatus(e);
        }
        monitor.done();
        return result;
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        RepositoryId repo = PullRequestConnector.getRepository(repository.getRepositoryUrl());
        try {
            GitHubClient client = IssueConnector.createClient(repository);
            PullRequestService service = new PullRequestService(client);
            PullRequest pr = service.getPullRequest((IRepositoryIdProvider)repo, Integer.parseInt(taskId));
            PullRequestComposite prComp = new PullRequestComposite();
            prComp.setRequest(pr);
            IssueService commentService = new IssueService(client);
            List comments = null;
            if (pr.getComments() > 0) {
                comments = commentService.getComments(repo.getOwner(), repo.getName(), taskId);
            }
            if (pr.getCommits() > 0) {
                prComp.setCommits(service.getCommits((IRepositoryIdProvider)repo, pr.getNumber()));
            }
            return this.taskDataHandler.createTaskData(repository, monitor, (IRepositoryIdProvider)repo, prComp, comments);
        }
        catch (IOException e) {
            throw new CoreException(GitHub.createWrappedStatus(e));
        }
    }

    public String getRepositoryUrlFromTaskUrl(String taskFullUrl) {
        int lastPull = taskFullUrl.lastIndexOf(SEGMENT_PULL);
        if (lastPull != -1) {
            return String.valueOf(taskFullUrl.substring(0, lastPull)) + "/pulls";
        }
        return null;
    }

    @Override
    public String getTaskUrl(String repositoryUrl, String taskId) {
        return String.valueOf(PullRequestConnector.stripPulls(repositoryUrl)) + SEGMENT_PULL + "/" + taskId;
    }
}

