/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jenkins.core.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.builds.core.spi.AbstractConfigurationCache;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpResponse;
import org.eclipse.mylyn.commons.repositories.http.core.HttpUtil;
import org.eclipse.mylyn.internal.hudson.model.HudsonMavenReportersSurefireAggregatedReport;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelBuild;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelHudson;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelJob;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelProject;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelRun;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelRunArtifact;
import org.eclipse.mylyn.internal.hudson.model.HudsonTasksJunitTestResult;
import org.eclipse.mylyn.internal.hudson.model.HudsonTasksTestAggregatedTestResultActionChildReport;
import org.eclipse.mylyn.internal.jenkins.core.client.JenkinsConfiguration;
import org.eclipse.mylyn.internal.jenkins.core.client.JenkinsConfigurationCache;
import org.eclipse.mylyn.internal.jenkins.core.client.JenkinsException;
import org.eclipse.mylyn.internal.jenkins.core.client.JenkinsOperation;
import org.eclipse.mylyn.internal.jenkins.core.client.JenkinsRunBuildForm;
import org.eclipse.mylyn.internal.jenkins.core.client.JenkinsServerInfo;
import org.eclipse.mylyn.internal.jenkins.core.client.JenkinsTestReport;
import org.eclipse.mylyn.internal.jenkins.core.client.JenkinsUrl;
import org.eclipse.mylyn.internal.jenkins.core.client.JenkinsUrlUtil;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RestfulJenkinsClient {
    private static final String URL_API = "/api/xml";
    private static final int JOB_RETRIEVE_BATCH_SIZE = 50;
    private AbstractConfigurationCache<JenkinsConfiguration> cache;
    private final CommonHttpClient client;
    private final JenkinsUrlUtil jenkinsUrlUtil;
    private volatile JenkinsServerInfo info;

    public RestfulJenkinsClient(RepositoryLocation location, JenkinsConfigurationCache cache) {
        this.client = new CommonHttpClient(location);
        this.setCache(cache);
        this.jenkinsUrlUtil = new JenkinsUrlUtil(location);
    }

    public List<HudsonModelRun> getBuilds(final HudsonModelJob job, final IOperationMonitor monitor) throws JenkinsException {
        return (List)new JenkinsOperation<List<HudsonModelRun>>(this.client){

            @Override
            public List<HudsonModelRun> execute() throws IOException, JenkinsException, JAXBException {
                String url = JenkinsUrl.create(RestfulJenkinsClient.this.getJobUrl(job)).depth(1).tree("builds[number,url,building,result,duration,timestamp,actions[causes[shortDescription],failCount,totalCount,skipCount]]").toUrl();
                HttpGet request = this.createGetRequest(url);
                CommonHttpResponse response = this.execute((HttpRequestBase)request, monitor);
                return (List)this.processAndRelease(response, monitor);
            }

            @Override
            protected List<HudsonModelRun> doProcess(CommonHttpResponse response, IOperationMonitor monitor2) throws IOException, JenkinsException, JAXBException {
                InputStream in = response.getResponseEntityAsStream();
                HudsonModelProject project = RestfulJenkinsClient.unmarshal(RestfulJenkinsClient.this.parse(in, response.getRequestPath()), HudsonModelProject.class);
                return project.getBuild();
            }
        }.run();
    }

    public HudsonModelBuild getBuild(final HudsonModelJob job, final HudsonModelRun build, final IOperationMonitor monitor) throws JenkinsException {
        return (HudsonModelBuild)new JenkinsOperation<HudsonModelBuild>(this.client){

            @Override
            public HudsonModelBuild execute() throws IOException, JenkinsException, JAXBException {
                String url = String.valueOf(RestfulJenkinsClient.this.getBuildUrl(job, build)) + RestfulJenkinsClient.URL_API;
                HttpGet request = this.createGetRequest(url);
                CommonHttpResponse response = this.execute((HttpRequestBase)request, monitor);
                return (HudsonModelBuild)this.processAndRelease(response, monitor);
            }

            @Override
            protected HudsonModelBuild doProcess(CommonHttpResponse response, IOperationMonitor monitor2) throws IOException, JenkinsException, JAXBException {
                InputStream in = response.getResponseEntityAsStream();
                HudsonModelBuild hudsonBuild = RestfulJenkinsClient.unmarshal(RestfulJenkinsClient.this.parse(in, response.getRequestPath()), HudsonModelBuild.class);
                return hudsonBuild;
            }
        }.run();
    }

    public JenkinsTestReport getTestReport(final HudsonModelJob job, final HudsonModelRun build, final IOperationMonitor monitor) throws JenkinsException {
        return (JenkinsTestReport)new JenkinsOperation<JenkinsTestReport>(this.client){

            @Override
            public JenkinsTestReport execute() throws IOException, JenkinsException, JAXBException {
                String resultTree = "duration,failCount,passCount,skipCount,suites[cases[className,duration,errorDetails,errorStackTrace,failedSince,name,skipped,status],duration,name,stderr,stdout]";
                String aggregatedTree = "failCount,skipCount,totalCount,childReports[child[number,url],result[" + resultTree + "]]";
                String url = JenkinsUrl.create(String.valueOf(RestfulJenkinsClient.this.getBuildUrl(job, build)) + "/testReport").tree(String.valueOf(resultTree) + "," + aggregatedTree).toUrl();
                HttpGet request = this.createGetRequest(url);
                CommonHttpResponse response = this.execute((HttpRequestBase)request, monitor);
                return (JenkinsTestReport)this.processAndRelease(response, monitor);
            }

            @Override
            protected JenkinsTestReport doProcess(CommonHttpResponse response, IOperationMonitor monitor2) throws IOException, JenkinsException, JAXBException {
                InputStream in = response.getResponseEntityAsStream();
                Element element = RestfulJenkinsClient.this.parse(in, response.getRequestPath());
                if ("surefireAggregatedReport".equals(element.getNodeName())) {
                    HudsonMavenReportersSurefireAggregatedReport report = RestfulJenkinsClient.unmarshal(element, HudsonMavenReportersSurefireAggregatedReport.class);
                    for (HudsonTasksTestAggregatedTestResultActionChildReport child : report.getChildReport()) {
                        child.setResult(RestfulJenkinsClient.unmarshal((Node)child.getResult(), HudsonTasksJunitTestResult.class));
                    }
                    return new JenkinsTestReport(report);
                }
                return new JenkinsTestReport(RestfulJenkinsClient.unmarshal(element, HudsonTasksJunitTestResult.class));
            }
        }.run();
    }

    protected String getBuildUrl(HudsonModelJob job, HudsonModelRun build) throws JenkinsException {
        if (build.getNumber() == -1) {
            return String.valueOf(this.getJobUrl(job)) + "/lastBuild";
        }
        return String.valueOf(this.getJobUrl(job)) + "/" + build.getNumber();
    }

    public String getArtifactUrl(HudsonModelJob job, HudsonModelRun build, HudsonModelRunArtifact artifact) throws JenkinsException {
        return String.valueOf(this.getBuildUrl(job, build)) + "/artifact/" + artifact.getRelativePath();
    }

    public AbstractConfigurationCache<JenkinsConfiguration> getCache() {
        return this.cache;
    }

    public JenkinsConfiguration getConfiguration() {
        return (JenkinsConfiguration)this.getCache().getConfiguration(this.client.getLocation().getUrl());
    }

    public Reader getConsole(final HudsonModelJob job, final HudsonModelBuild hudsonBuild, final IOperationMonitor monitor) throws JenkinsException {
        return (Reader)new JenkinsOperation<Reader>(this.client){

            @Override
            public Reader execute() throws IOException, JenkinsException, JAXBException {
                HttpGet request = this.createGetRequest(String.valueOf(RestfulJenkinsClient.this.getBuildUrl(job, hudsonBuild)) + "/consoleText");
                CommonHttpResponse response = this.execute((HttpRequestBase)request, monitor);
                return (Reader)this.process(response, monitor);
            }

            @Override
            protected Reader doProcess(CommonHttpResponse response, IOperationMonitor monitor2) throws IOException, JenkinsException {
                InputStream in = response.getResponseEntityAsStream();
                String charSet = response.getResponseCharSet();
                if (charSet == null) {
                    charSet = "UTF-8";
                }
                return new InputStreamReader(in, charSet);
            }
        }.run();
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    public List<HudsonModelJob> getJobs(List<String> ids, IOperationMonitor monitor) throws JenkinsException {
        if (ids != null && ids.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HudsonModelJob> jobs = new ArrayList();
        if (ids != null) {
            Map<String, List<String>> jobNamesByFolderUrl = this.jenkinsUrlUtil.groupJobNamesByFolderUrl(ids);
            for (String folderUrl : jobNamesByFolderUrl.keySet()) {
                List<String> jobNames = jobNamesByFolderUrl.get(folderUrl);
                int batchStartIndex = 0;
                while (batchStartIndex < jobNames.size()) {
                    List<String> jobNamesBatch = jobNames.subList(batchStartIndex, Math.min(batchStartIndex + 50, jobNames.size()));
                    jobs.addAll(this.getJobsFromFolder(folderUrl, jobNamesBatch, monitor));
                    batchStartIndex += 50;
                }
            }
        } else {
            jobs = this.getJobsFromFolder(this.jenkinsUrlUtil.baseUrl(), ids, monitor);
            this.updateConfiguration(jobs);
        }
        return jobs;
    }

    private void updateConfiguration(List<HudsonModelJob> jobs) throws JenkinsException {
        HashMap<String, String> jobNameById = new HashMap<String, String>();
        for (HudsonModelJob job : jobs) {
            String jobUrl = job.getUrl();
            String displayName = this.jenkinsUrlUtil.getDisplayName(jobUrl);
            if (jobUrl != null && this.jenkinsUrlUtil.isNestedJob(jobUrl)) {
                jobNameById.put(jobUrl, displayName);
                continue;
            }
            jobNameById.put(job.getName(), displayName);
        }
        JenkinsConfiguration configuration = new JenkinsConfiguration();
        configuration.jobNameById = jobNameById;
        this.setConfiguration(configuration);
    }

    private List<HudsonModelJob> getJobsFromFolder(final String folderUrl, final List<String> ids, final IOperationMonitor monitor) throws JenkinsException {
        return (List)new JenkinsOperation<List<HudsonModelJob>>(this.client){

            @Override
            protected List<HudsonModelJob> execute() throws IOException, JenkinsException, JAXBException {
                String url = JenkinsUrl.create(folderUrl).depth(1).include("/*/job").match("name", ids).exclude("/*/job/build").toUrl();
                HttpGet request = this.createGetRequest(url);
                CommonHttpResponse response = this.execute((HttpRequestBase)request, monitor);
                return (List)this.processAndRelease(response, monitor);
            }

            @Override
            protected List<HudsonModelJob> doProcess(CommonHttpResponse response, IOperationMonitor monitor2) throws IOException, JenkinsException, JAXBException {
                InputStream in = response.getResponseEntityAsStream();
                HudsonModelHudson hudson = RestfulJenkinsClient.unmarshal(RestfulJenkinsClient.this.parse(in, response.getRequestPath()), HudsonModelHudson.class);
                ArrayList<HudsonModelJob> buildPlans = new ArrayList<HudsonModelJob>();
                List<Object> jobsNodes = hudson.getJob();
                HashSet<String> urls = new HashSet<String>();
                for (Object jobNode : jobsNodes) {
                    Node node = (Node)jobNode;
                    HudsonModelJob job = RestfulJenkinsClient.unmarshal(node, HudsonModelJob.class);
                    if (job.getColor() != null) {
                        String jobUrl = RestfulJenkinsClient.this.jenkinsUrlUtil.assembleJobUrl(job.getName(), folderUrl);
                        if (urls.contains(jobUrl)) continue;
                        job.setUrl(jobUrl);
                        buildPlans.add(job);
                        urls.add(jobUrl);
                        continue;
                    }
                    if (ids != null) continue;
                    buildPlans.addAll(RestfulJenkinsClient.this.getJobsFromFolder(job.getUrl(), ids, monitor2));
                }
                return buildPlans;
            }
        }.run();
    }

    String getJobUrl(HudsonModelJob job) throws JenkinsException {
        String url = job.getUrl();
        if (url != null) {
            return url;
        }
        return this.jenkinsUrlUtil.getJobUrlFromJobId(job.getName());
    }

    Element parse(InputStream in, String url) throws JenkinsException {
        try {
            return this.getDocumentBuilder().parse(in).getDocumentElement();
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new JenkinsException(NLS.bind((String)"Failed to parse response from {0}", (Object)url), e);
        }
        catch (Exception e) {
            throw new JenkinsException(NLS.bind((String)"Failed to parse response from {0}", (Object)url), e);
        }
    }

    public Document getJobConfig(final HudsonModelJob job, final IOperationMonitor monitor) throws JenkinsException {
        return (Document)new JenkinsOperation<Document>(this.client){

            @Override
            public Document execute() throws IOException, JenkinsException, JAXBException {
                HttpGet request = this.createGetRequest(String.valueOf(RestfulJenkinsClient.this.getJobUrl(job)) + "/config.xml");
                CommonHttpResponse response = this.execute((HttpRequestBase)request, monitor);
                return (Document)this.processAndRelease(response, monitor);
            }

            @Override
            protected Document doProcess(CommonHttpResponse response, IOperationMonitor monitor2) throws IOException, JenkinsException, JAXBException {
                InputStream in = response.getResponseEntityAsStream();
                try {
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    return builder.parse(in);
                }
                catch (ParserConfigurationException e) {
                    throw new JenkinsException(e);
                }
                catch (SAXException e) {
                    throw new JenkinsException(e);
                }
            }
        }.run();
    }

    public void runBuild(final HudsonModelJob job, final Map<String, String> parameters, final IOperationMonitor monitor) throws JenkinsException {
        new JenkinsOperation<Object>(this.client){

            @Override
            public Object execute() throws IOException, JenkinsException, JAXBException {
                HttpPost request = this.createPostRequest(String.valueOf(RestfulJenkinsClient.this.getJobUrl(job)) + "/build");
                if (parameters != null) {
                    JenkinsRunBuildForm form = new JenkinsRunBuildForm();
                    for (Map.Entry entry : parameters.entrySet()) {
                        form.add((String)entry.getKey(), (String)entry.getValue());
                    }
                    request.setEntity((HttpEntity)form.createEntity());
                }
                CommonHttpResponse response = this.execute((HttpRequestBase)request, monitor);
                return this.processAndRelease(response, monitor);
            }

            @Override
            protected void doValidate(CommonHttpResponse response, IOperationMonitor monitor2) throws IOException, JenkinsException {
                int statusCode = response.getStatusCode();
                if (statusCode != 201 && statusCode != 302) {
                    throw new JenkinsException(NLS.bind((String)"Unexpected response from Hudson server for ''{0}'': {1}", (Object)response.getRequestPath(), (Object)HttpUtil.getStatusText((int)statusCode)));
                }
            }
        }.run();
    }

    public void abortBuild(final HudsonModelJob job, final HudsonModelBuild build, final IOperationMonitor monitor) throws JenkinsException {
        new JenkinsOperation<Object>(this.client){

            @Override
            public Object execute() throws IOException, JenkinsException, JAXBException {
                HttpPost request = this.createPostRequest(String.valueOf(RestfulJenkinsClient.this.getJobUrl(job)) + build.getNumber() + "/stop");
                CommonHttpResponse response = this.execute((HttpRequestBase)request, monitor);
                return this.processAndRelease(response, monitor);
            }

            @Override
            protected void doValidate(CommonHttpResponse response, IOperationMonitor monitor2) throws IOException, JenkinsException {
                int statusCode = response.getStatusCode();
                if (statusCode != 200 && statusCode != 302) {
                    throw new JenkinsException(NLS.bind((String)"Unexpected response from Hudson server for ''{0}'': {1}", (Object)response.getRequestPath(), (Object)HttpUtil.getStatusText((int)statusCode)));
                }
            }
        }.run();
    }

    public void setCache(AbstractConfigurationCache<JenkinsConfiguration> cache) {
        Assert.isNotNull(cache);
        this.cache = cache;
    }

    protected void setConfiguration(JenkinsConfiguration configuration) {
        this.getCache().setConfiguration(this.client.getLocation().getUrl(), (Serializable)configuration);
    }

    public static <T> T unmarshal(Node node, Class<T> clazz) throws JAXBException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = ctx.createUnmarshaller();
        JAXBElement hudsonElement = unmarshaller.unmarshal(node, clazz);
        return (T)hudsonElement.getValue();
    }

    public JenkinsServerInfo validate(final IOperationMonitor monitor) throws JenkinsException {
        this.info = (JenkinsServerInfo)new JenkinsOperation<JenkinsServerInfo>(this.client){

            @Override
            public JenkinsServerInfo execute() throws IOException, JenkinsException, JAXBException {
                HttpGet request = this.createGetRequest(this.baseUrl());
                CommonHttpResponse response = this.execute((HttpRequestBase)request, monitor);
                return (JenkinsServerInfo)this.processAndRelease(response, monitor);
            }

            @Override
            protected JenkinsServerInfo doProcess(CommonHttpResponse response, IOperationMonitor monitor2) throws IOException, JenkinsException, JAXBException {
                JenkinsServerInfo.Type type;
                Header header = response.getResponse().getFirstHeader("X-Jenkins");
                if (header == null) {
                    type = JenkinsServerInfo.Type.HUDSON;
                    header = response.getResponse().getFirstHeader("X-Hudson");
                    if (header == null) {
                        throw new JenkinsException(NLS.bind((String)"{0} does not appear to be a Hudson or Jenkins instance", (Object)this.baseUrl()));
                    }
                } else {
                    type = JenkinsServerInfo.Type.JENKINS;
                }
                JenkinsServerInfo info = new JenkinsServerInfo(type, header.getValue());
                return info;
            }
        }.run();
        return this.info;
    }

    public RepositoryLocation getLocation() {
        return this.client.getLocation();
    }

    public JenkinsServerInfo getInfo() {
        return this.info;
    }

    public JenkinsServerInfo getInfo(IOperationMonitor monitor) throws JenkinsException {
        JenkinsServerInfo info = this.info;
        if (info != null) {
            return info;
        }
        return this.validate(monitor);
    }

    public void reset() {
        this.client.getHttpClient().getCookieStore().clear();
    }

    public static enum BuildId {
        LAST(-1),
        LAST_FAILED(-5),
        LAST_STABLE(-2),
        LAST_SUCCESSFUL(-3),
        LAST_UNSTABLE(-4);

        private HudsonModelBuild build = new HudsonModelBuild();

        private BuildId(int id) {
            this.build.setNumber(id);
        }

        public HudsonModelBuild getBuild() {
            return this.build;
        }
    }
}

